<?php
// Habilitar errores temporalmente para debug
// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);

session_start();

// Guardar información de la sesión antes de destruirla (opcional para logs)
$user_id = $_SESSION['user_id'] ?? 'No identificado';
$user_nombre = $_SESSION['user_nombre'] ?? 'Usuario desconocido';

// Registrar cierre de sesión (opcional para auditoría)
error_log("Cierre de sesión - Usuario ID: $user_id, Nombre: $user_nombre");

// Destruir todas las variables de sesión
$_SESSION = array();

// Si se desea destruir la sesión completamente, borrar también la cookie de sesión
if (ini_get("session.use_cookies")) {
    $params = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000,
        $params["path"], $params["domain"],
        $params["secure"], $params["httponly"]
    );
}

// Finalmente, destruir la sesión
session_destroy();

// Redireccionar a la página de login con mensaje de éxito
header("Location: login.php?logout=success");
exit();
?>