<?php
// Archivo para mostrar detalles de una visita específica
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();

// Verificar sesión
if (!isset($_SESSION['user_id'])) {
    die("Acceso no autorizado");
}

require_once '../../config/database.php';

$database = new Database();
$db = $database->getConnection();

if (!$db) {
    die("Error de conexión a la base de datos");
}

$id = $_GET['id'] ?? 0;

if ($id > 0) {
    try {
        $query = "SELECT v.*, a.nombre_area as area_nombre, 
                  CONCAT(u.nombres, ' ', u.apellidos) as usuario_registra,
                  u.dni as usuario_dni,
                  u.correo as usuario_correo
                  FROM visitas v 
                  LEFT JOIN areas a ON v.area_id = a.id 
                  LEFT JOIN usuarios u ON v.usuario_registra_id = u.id 
                  WHERE v.id = :id";
        
        $stmt = $db->prepare($query);
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        $stmt->execute();
        $visita = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($visita) {
            // Determinar estado y color
            $estado = $visita['hora_salida'] ? 'Completada' : 'Activa';
            $color_estado = $visita['hora_salida'] ? 'success' : 'warning';
            $icono_estado = $visita['hora_salida'] ? 'check-circle' : 'clock';
            
            // Calcular duración si está completada
            $duracion = '';
            if ($visita['hora_salida']) {
                $hora_ingreso = strtotime($visita['hora_ingreso']);
                $hora_salida = strtotime($visita['hora_salida']);
                $tiempo = $hora_salida - $hora_ingreso;
                $horas = floor($tiempo / 3600);
                $minutos = floor(($tiempo % 3600) / 60);
                $duracion = sprintf("%02d:%02d", $horas, $minutos);
            }
            ?>
            <div class="row">
                <div class="col-md-6">
                    <h5>Información del Visitante</h5>
                    <table class="table table-sm">
                        <tr>
                            <th width="40%">Nombre completo:</th>
                            <td><?php echo htmlspecialchars($visita['apellidos_visitante'] . ', ' . $visita['nombres_visitante']); ?></td>
                        </tr>
                        <tr>
                            <th>Documento:</th>
                            <td>
                                <span class="badge bg-secondary">
                                    <?php echo htmlspecialchars($visita['documento_visitante']); ?>
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <th>Área visitada:</th>
                            <td><?php echo htmlspecialchars($visita['area_nombre'] ?? 'No especificada'); ?></td>
                        </tr>
                        <tr>
                            <th>Fecha de visita:</th>
                            <td><?php echo date('d/m/Y', strtotime($visita['fecha_visita'])); ?></td>
                        </tr>
                    </table>
                </div>
                
                <div class="col-md-6">
                    <h5>Información del Registro</h5>
                    <table class="table table-sm">
                        <tr>
                            <th width="40%">Estado:</th>
                            <td>
                                <span class="badge bg-<?php echo $color_estado; ?>">
                                    <i class="fas fa-<?php echo $icono_estado; ?> me-1"></i>
                                    <?php echo $estado; ?>
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <th>Hora de ingreso:</th>
                            <td>
                                <strong><?php echo date('H:i:s', strtotime($visita['hora_ingreso'])); ?></strong>
                                <small class="text-muted ms-2">
                                    (<?php echo $visita['tipo_ingreso'] == 'manual' ? 'Manual' : 'Automático'; ?>)
                                </small>
                            </td>
                        </tr>
                        <?php if ($visita['hora_salida']): ?>
                        <tr>
                            <th>Hora de salida:</th>
                            <td>
                                <strong class="text-success"><?php echo date('H:i:s', strtotime($visita['hora_salida'])); ?></strong>
                                <small class="text-muted ms-2">
                                    (<?php echo $visita['tipo_salida'] == 'manual' ? 'Manual' : 'Automático'; ?>)
                                </small>
                            </td>
                        </tr>
                        <tr>
                            <th>Duración total:</th>
                            <td><strong><?php echo $duracion; ?></strong> (hh:mm)</td>
                        </tr>
                        <?php endif; ?>
                        <tr>
                            <th>Registrado por:</th>
                            <td><?php echo htmlspecialchars($visita['usuario_registra'] ?? 'No registrado'); ?></td>
                        </tr>
                        <tr>
                            <th>Fecha registro:</th>
                            <td><?php echo date('d/m/Y H:i:s', strtotime($visita['fecha_registro'])); ?></td>
                        </tr>
                    </table>
                </div>
            </div>
            
            <div class="row mt-3">
                <div class="col-12">
                    <h5>Motivo de la visita</h5>
                    <div class="card bg-light">
                        <div class="card-body">
                            <p class="mb-0"><?php echo nl2br(htmlspecialchars($visita['motivo_visita'])); ?></p>
                        </div>
                    </div>
                </div>
            </div>
            
            <?php if (!empty($visita['observaciones'])): ?>
            <div class="row mt-3">
                <div class="col-12">
                    <h5>Observaciones</h5>
                    <div class="card bg-light">
                        <div class="card-body">
                            <p class="mb-0"><?php echo nl2br(htmlspecialchars($visita['observaciones'])); ?></p>
                        </div>
                    </div>
                </div>
            </div>
            <?php endif; ?>
            
            <div class="row mt-4">
                <div class="col-12">
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle me-2"></i>
                        <small>
                            ID de registro: <?php echo $visita['id']; ?> | 
                            Área ID: <?php echo $visita['area_id']; ?> |
                            Usuario ID: <?php echo $visita['usuario_registra_id']; ?>
                        </small>
                    </div>
                </div>
            </div>
            <?php
        } else {
            echo '<div class="alert alert-warning">No se encontró la visita solicitada.</div>';
        }
        
    } catch (PDOException $e) {
        echo '<div class="alert alert-danger">Error: ' . htmlspecialchars($e->getMessage()) . '</div>';
    }
} else {
    echo '<div class="alert alert-danger">ID de visita no especificado.</div>';
}
?>