<?php
require_once 'config/database.php';
require_once 'config/email.php';

$database = new Database();
$db = $database->getConnection();

$mensaje = '';
$tipo_mensaje = '';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $email = trim($_POST['email']);
    
    // Verificar si el email existe
    $query = "SELECT id, dni, nombres, apellidos FROM usuarios WHERE correo = :email AND activo = 1";
    $stmt = $db->prepare($query);
    $stmt->bindParam(':email', $email);
    $stmt->execute();
    
    if ($stmt->rowCount() > 0) {
        $usuario = $stmt->fetch(PDO::FETCH_ASSOC);
        
        // Generar token único
        $token = bin2hex(random_bytes(32));
        $expiracion = date('Y-m-d H:i:s', strtotime('+1 hour'));
        
        // Guardar token en la base de datos
        $query = "UPDATE usuarios SET token_recuperacion = :token WHERE id = :id";
        $stmt = $db->prepare($query);
        $stmt->bindParam(':token', $token);
        $stmt->bindParam(':id', $usuario['id']);
        
        if ($stmt->execute()) {
            // Enviar email con el enlace de recuperación
            $emailSender = new EmailSender();
            $nombre = $usuario['nombres'] . ' ' . $usuario['apellidos'];
            
            if ($emailSender->enviarRecuperacion($email, $nombre, $token)) {
                $mensaje = "Se ha enviado un enlace de recuperación a tu correo electrónico. Revisa tu bandeja de entrada.";
                $tipo_mensaje = "success";
            } else {
                $mensaje = "Error al enviar el correo. Por favor, intenta nuevamente.";
                $tipo_mensaje = "danger";
            }
        }
    } else {
        $mensaje = "No se encontró ninguna cuenta con ese correo electrónico.";
        $tipo_mensaje = "warning";
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Recuperar Contraseña - Sistema de Visitas</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #e3f2fd 0%, #bbdefb 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
        }
        .recovery-card {
            background: white;
            border-radius: 20px;
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.1);
            overflow: hidden;
            animation: fadeIn 0.5s ease-out;
        }
        .recovery-header {
            background: linear-gradient(to right, #1976d2, #2196f3);
            color: white;
            padding: 30px;
            text-align: center;
        }
        .recovery-body {
            padding: 30px;
        }
        .btn-recovery {
            background: linear-gradient(to right, #1976d2, #2196f3);
            border: none;
            padding: 12px;
            font-weight: 600;
            transition: all 0.3s;
        }
        .btn-recovery:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(33, 150, 243, 0.4);
        }
        .recovery-icon {
            width: 80px;
            height: 80px;
            background: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 20px;
        }
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-6 col-lg-5">
                <div class="recovery-card">
                    <div class="recovery-header">
                        <div class="recovery-icon">
                            <i class="fas fa-key fa-2x" style="color: #1976d2;"></i>
                        </div>
                        <h3>Recuperar Contraseña</h3>
                        <p class="mb-0">Sistema de Visitas</p>
                    </div>
                    <div class="recovery-body">
                        <?php if ($mensaje): ?>
                            <div class="alert alert-<?php echo $tipo_mensaje; ?> alert-dismissible fade show" role="alert">
                                <?php echo $mensaje; ?>
                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                            </div>
                        <?php endif; ?>
                        
                        <p class="text-muted mb-4">
                            Ingresa tu correo electrónico registrado. Te enviaremos un enlace para restablecer tu contraseña.
                        </p>
                        
                        <form method="POST" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>">
                            <div class="mb-4">
                                <label for="email" class="form-label">Correo Electrónico</label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="fas fa-envelope"></i></span>
                                    <input type="email" class="form-control" id="email" name="email" 
                                           required placeholder="nombre@ejemplo.com">
                                </div>
                            </div>
                            
                            <div class="d-grid mb-4">
                                <button type="submit" class="btn btn-recovery">
                                    <i class="fas fa-paper-plane me-2"></i>Enviar Enlace de Recuperación
                                </button>
                            </div>
                            
                            <div class="text-center">
                                <a href="login.php" class="text-decoration-none">
                                    <i class="fas fa-arrow-left me-1"></i>Volver al Inicio de Sesión
                                </a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://kit.fontawesome.com/your-fontawesome-kit.js" crossorigin="anonymous"></script>
</body>
</html>